/*** 1.   ũƮ ***/

SELECT ROW_NUMBER() OVER (ORDER BY a.number) seq
	, CONVERT(INT, RIGHT(a.number*b.number*a.high,2)) AS value
	, NEWID() txt
	, DATEADD(dd,b.number,'2020-01-01') date 
INTO TB_Sum
FROM master..spt_values a, master..spt_values b 
WHERE a.type = 'P'
AND b.type = 'P'
AND a.number BETWEEN 1 AND 1000
AND b.number BETWEEN 1 AND 1000

CREATE CLUSTERED INDEX CIDX_CNT ON TB_Sum(date) 
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT sum_total, sum_1, sum_2, sum_3, sum_4
FROM (SELECT SUM(value) sum_total
      FROM TB_Sum 
      WHERE date BETWEEN '2020-01-01' AND '2020-12-31') a 
CROSS JOIN
     (SELECT SUM(value) sum_1
      FROM TB_Sum
      WHERE date BETWEEN '2020-01-01' AND '2020-03-31') b 
CROSS JOIN
     (SELECT SUM(value) sum_2
      FROM TB_Sum
      WHERE date BETWEEN '2020-04-01' AND '2020-06-30') c 
CROSS JOIN
     (SELECT SUM(value) sum_3
      FROM TB_Sum
      WHERE date BETWEEN '2020-07-01' AND '2020-09-30') d 
CROSS JOIN
     (SELECT SUM(value) sum_4
      FROM TB_Sum
      WHERE date BETWEEN '2020-10-01' AND '2020-12-31') e
GO


/*** 6. [TO-BE]   ***/

SELECT sum_1+sum_2+sum_3+sum_4 as sum_total, sum_1, sum_2, sum_3, sum_4
FROM (SELECT SUM(value) sum_1 
	 FROM TB_Sum 
	 WHERE date BETWEEN '2020-01-01' AND '2020-03-31') b 
CROSS JOIN (SELECT SUM(value) sum_2 
	       FROM TB_Sum 
	       WHERE date BETWEEN '2020-04-01' AND '2020-06-30') c 
CROSS JOIN (SELECT SUM(value) sum_3 
	       FROM TB_Sum 
	       WHERE date BETWEEN '2020-07-01' AND '2020-09-30') d 
CROSS JOIN(SELECT SUM(value) sum_4 
	      FROM TB_Sum 
	      WHERE date BETWEEN '2020-10-01' AND '2020-12-31') e
GO


